/*
 * Decompiled with CFR 0.152.
 */
public class Main
implements SQLRequestListener {
    String host;
    Integer port;
    String dbname;
    String username;
    String password;
    SybaseDB db;
    StdInputReader input;

    public static void main(String[] args) {
        String pw = "";
        if (args.length != 5 && args.length != 4) {
            System.err.println("Expecting the arguments: host, port, dbname, username, password");
            System.exit(1);
        }
        if (args.length == 5) {
            pw = args[4];
        }
        Main m = new Main(args[0], Integer.parseInt(args[1]), args[2], args[3], pw);
    }

    public Main(String host, Integer port, String dbname, String username, String password) {
        this.host = host;
        this.port = port;
        this.dbname = dbname;
        this.username = username;
        this.password = password;
        this.input = new StdInputReader();
        this.input.addListener(this);
        MyProperties props = new MyProperties("sybaseConfig.properties");
        this.db = new SybaseDB(host, port, dbname, username, password, props.properties);
        if (!this.db.connect()) {
            System.exit(1);
        }
        System.out.println("connected");
        this.input.startReadLoop();
    }

    public void sqlRequest(SQLRequest request) {
        this.db.execSQL(request);
    }
}

